/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.DeviceClassProperties;
import com.ibm.hwmca.fw.mediasvc.DevicePropertiesFilenameFilter;
import com.ibm.hwmca.fw.mediasvc.HdDeviceProperties;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.mediasvc.MediaServicesResourceBundle;
import com.ibm.hwmca.fw.mediasvc.NonHdDeviceProperties;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class DiscoverDevices
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    private static final String TRACE_MASKT = "XMDADMDT";
    private static final String TRACE_MASKF = "XMDADMDF";
    private static final String TRACE_MASKD = "XMDADMDD";
    private static final String HD_PREFIX = "hd.";
    private static final String HD_PARTITION_PREFIX = "hd.partition.";
    private static final String NAME_SUFFIX = ".name";
    private static final String DESCRIPTION_SUFFIX = ".description";
    private static final String HDPROPERTIES = "media.hd.partition.info";
    private static final String DEVPROPERTIES = "media.device.properties";
    private MediaServicesParameters mediaServicesParameters;
    private HashMap deviceClassPropertiesMap;
    private HashMap detectedDevicesMap;
    private HashMap detectedDeviceIdsMap;

    DiscoverDevices() {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.DiscoverDevices()");
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        this.deviceClassPropertiesMap = new HashMap();
        this.detectedDevicesMap = new HashMap();
        this.detectedDeviceIdsMap = new HashMap();
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.DiscoverDevices()");
    }

    HashMap getHashMapOfDevices() throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getHashMapOfDevices()");
        String devicePropertiesDirName = "";
        try {
            devicePropertiesDirName = BaseFileControl.getFilePath(this.mediaServicesParameters.getParm(DEVPROPERTIES)) + this.mediaServicesParameters.getParm(DEVPROPERTIES);
            Trace.trace(TRACE_MASKD, "DiscoverDevices.getHashMapOfDevices(): devicePropertiesDirName = " + devicePropertiesDirName);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        File devicePropertiesDir = new File(devicePropertiesDirName);
        DevicePropertiesFilenameFilter devicePropertiesFilenameFilter = new DevicePropertiesFilenameFilter();
        String[] devicePropertyFiles = devicePropertiesDir.list(devicePropertiesFilenameFilter);
        for (int i = 0; i < devicePropertyFiles.length; ++i) {
            DeviceClassProperties deviceClassProperties = null;
            try {
                deviceClassProperties = new DeviceClassProperties(devicePropertiesDirName + devicePropertyFiles[i]);
                this.deviceClassPropertiesMap.put(deviceClassProperties.getDeviceType(), deviceClassProperties);
                continue;
            }
            catch (Exception exc) {
                MediaDeviceException mdexc = new MediaDeviceException(exc);
                Trace.trace(TRACE_MASKF, mdexc);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 610, mdexc).log();
                throw mdexc;
            }
        }
        this.instantiateNonHdDevices();
        this.instantiateHdDevices();
        Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfDevices(): Detected " + this.detectedDeviceIdsMap.size() + " devices");
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getHashMapOfDevices()");
        return this.detectedDeviceIdsMap;
    }

    private void instantiateHdDevices() throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.instantiateHdDevices()");
        try {
            String hdFile = BaseFileControl.getFilePath("data") + this.mediaServicesParameters.getParm(DEVPROPERTIES) + this.mediaServicesParameters.getParm(HDPROPERTIES);
            Trace.trace(TRACE_MASKD, "DiscoverDevices.instantiateHdDevices(): hdFile = " + hdFile);
            FileInputStream fileInputStream = new FileInputStream(hdFile);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            for (int i = 0; i < properties.size() / 3; ++i) {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Getting the device class properties for the new device.");
                DeviceClassProperties deviceClass = (DeviceClassProperties)this.deviceClassPropertiesMap.get("HD");
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Incrementing the number of devices.");
                deviceClass.incrementNumberOfDevices();
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The number of devices = " + deviceClass.getNumberOfDevices());
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Creating the new device.");
                HdDeviceProperties device = new HdDeviceProperties(deviceClass);
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Setting the mount point for the new device.");
                String index = new Integer(i + 1).toString();
                String mountPointKey = HD_PREFIX + index;
                device.setMountPoint(properties.getProperty(mountPointKey));
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The mount point for the hard drive = " + device.getMountPoint());
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Setting the displayable name for the new device.");
                String displayableNameKey = HD_PARTITION_PREFIX + index + NAME_SUFFIX;
                device.setDisplayableName(new LocalizableText(properties.getProperty(displayableNameKey)));
                Trace.trace(TRACE_MASKF, "The displayable name for the hard drive device = " + device.getDisplayableName());
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Setting the displayable description for the new device.");
                String displayableDescriptionKey = HD_PARTITION_PREFIX + index + DESCRIPTION_SUFFIX;
                device.setDisplayableDescription(new LocalizableText(properties.getProperty(displayableDescriptionKey)));
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The displayable description for the hard drive device = " + device.getDisplayableDescription());
                if (properties.getProperty(mountPointKey).indexOf("upgrade") != -1) {
                    device.setPreferred(true);
                } else {
                    device.setPreferred(false);
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Adding the new device to the device hash map.");
                this.detectedDevicesMap.put(device.getDeviceName(), device);
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Adding the new device id to the device id hash map.");
                this.detectedDeviceIdsMap.put(device.getDeviceName(), new MediaDeviceIdentifier(device));
            }
        }
        catch (Exception exc) {
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            Trace.trace(TRACE_MASKF, mdexc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 613, mdexc).log();
        }
        Trace.trace(TRACE_MASKT, "DiscoverDevices.instantiateHdDevices()");
    }

    private void instantiateNonHdDevices() throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.instantiateNonHdDevices()");
        Trace.trace(TRACE_MASKD, "DiscoverDevices.instantiateNonHdDevices(): Detecting the floppy drive(s)...");
        String deviceType = "DD";
        Trace.trace(TRACE_MASKD, "DiscoverDevices.instantiateNonHdDevices(): device type = " + deviceType);
        String deviceFile = "fd0";
        Trace.trace(TRACE_MASKD, "DiscoverDevices.instantiateNonHdDevices(): device file = " + deviceFile);
        DeviceClassProperties deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
        if (deviceClassProperties != null) {
            deviceClassProperties.incrementNumberOfDevices();
            NonHdDeviceProperties nonHdDeviceProperties = new NonHdDeviceProperties(deviceClassProperties);
            nonHdDeviceProperties.setDeviceFile(deviceFile);
            this.setDisplayableName(nonHdDeviceProperties);
            this.detectedDevicesMap.put(nonHdDeviceProperties.getDeviceName(), nonHdDeviceProperties);
            this.detectedDeviceIdsMap.put(nonHdDeviceProperties.getDeviceName(), new MediaDeviceIdentifier(nonHdDeviceProperties));
        }
        Trace.trace(TRACE_MASKD, "DiscoverDevices.discoverDevices(): Detecting IDE drive(s)...");
        char[] chars = new char[]{'a', 'b', 'c', 'd'};
        for (int i = 0; i < chars.length; ++i) {
            String[] deviceInfo = this.readIde(chars[i]);
            deviceType = deviceInfo[0];
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): device type = " + deviceType);
            deviceFile = deviceInfo[1];
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): device file = " + deviceFile);
            if (deviceType == null || deviceType.equals("") || deviceFile == null || deviceFile.equals("") || (deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType)) == null) continue;
            deviceClassProperties.incrementNumberOfDevices();
            NonHdDeviceProperties nonHdDeviceProperties = new NonHdDeviceProperties(deviceClassProperties);
            nonHdDeviceProperties.setDeviceFile(deviceFile);
            this.setDisplayableName(nonHdDeviceProperties);
            this.detectedDevicesMap.put(nonHdDeviceProperties.getDeviceName(), nonHdDeviceProperties);
            this.detectedDeviceIdsMap.put(nonHdDeviceProperties.getDeviceName(), new MediaDeviceIdentifier(nonHdDeviceProperties));
        }
        Set set = this.deviceClassPropertiesMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            DeviceClassProperties dcp = (DeviceClassProperties)mapEntry.getValue();
            if (dcp.getNumberOfDevices() <= 0) continue;
            this.setDisplayableDescription(dcp);
            this.setPreferred(dcp);
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.instantiateNonHdDevices()");
    }

    private void setDisplayableName(MediaDeviceProperties mediaDeviceProperties) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.setDisplayableName(" + mediaDeviceProperties + ")");
        if (mediaDeviceProperties.getDeviceType().equals("DD")) {
            mediaDeviceProperties.setDisplayableName(new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.device.diskette")));
        } else if (mediaDeviceProperties.getDeviceType().equals("DV")) {
            mediaDeviceProperties.setDisplayableName(new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.device.dvdram")));
        } else if (mediaDeviceProperties.getDeviceType().equals("CD")) {
            mediaDeviceProperties.setDisplayableName(new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.device.cdrom")));
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.setDisplayableName()");
    }

    private void setDisplayableDescription(DeviceClassProperties deviceClassProperties) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.setDisplayableDescription(" + deviceClassProperties + ")");
        if (deviceClassProperties.getNumberOfDevices() == 1) {
            Set set = this.detectedDevicesMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                MediaDeviceProperties mediaDeviceProperties = (MediaDeviceProperties)mapEntry.getValue();
                if (!mediaDeviceProperties.getDeviceType().equals(deviceClassProperties.getDeviceType())) continue;
                mediaDeviceProperties.setDisplayableDescription(mediaDeviceProperties.getDisplayableName());
                break;
            }
        } else {
            Set set = this.detectedDevicesMap.entrySet();
            Iterator iterator = set.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                MediaDeviceProperties mediaDeviceProperties = (MediaDeviceProperties)mapEntry.getValue();
                if (!mediaDeviceProperties.getDeviceType().equals(deviceClassProperties.getDeviceType())) continue;
                String count = MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), MediaServicesResourceBundle.NumberOfDevices(++i));
                String description = mediaDeviceProperties.getDisplayableName().toString() + " " + count;
                mediaDeviceProperties.setDisplayableDescription(new LocalizableText(description));
            }
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.setDisplayableDescription()");
    }

    private void setPreferred(DeviceClassProperties deviceClassProperties) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.setPreferred(" + deviceClassProperties + ")");
        Set set = this.detectedDevicesMap.entrySet();
        Iterator iterator = set.iterator();
        MediaDeviceProperties preferredDevice = null;
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            MediaDeviceProperties mediaDeviceProperties = (MediaDeviceProperties)mapEntry.getValue();
            if (!mediaDeviceProperties.getDeviceType().equals(deviceClassProperties.getDeviceType())) continue;
            if (preferredDevice == null) {
                preferredDevice = mediaDeviceProperties;
                continue;
            }
            if (mediaDeviceProperties.getDeviceFile().compareTo(preferredDevice.getDeviceFile()) >= 0) continue;
            preferredDevice = mediaDeviceProperties;
        }
        if (preferredDevice != null) {
            preferredDevice.setPreferred(true);
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.setPreferred()");
    }

    private String[] readIde(char abcd) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.readIde(" + abcd + ")");
        String[] returnValues = new String[2];
        String deviceType = "";
        String deviceFile = "";
        String mediaType = "";
        String proc_ide_media = "/proc/ide/hdx/media";
        String mediaTemp = proc_ide_media.replace('x', abcd);
        String modelType = "";
        String proc_ide_model = "/proc/ide/hdx/model";
        String modelTemp = proc_ide_model.replace('x', abcd);
        String[] outputStreams = this.executeCommand("cat " + mediaTemp);
        String stdout = outputStreams[0];
        String stderr = outputStreams[1];
        if (stderr.length() != 0) {
            int index = stderr.indexOf("No such");
            if (index != -1) {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.readIde(): IDE device hd" + abcd + " not found.");
            } else {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.readIde(): Error performing cat " + mediaTemp + "; " + stderr + "\n");
            }
        } else {
            mediaType = stdout.trim();
            Trace.trace(TRACE_MASKF, "DiscoverDevices.readIde(): cat " + mediaTemp + ", found hd" + abcd + " = [" + mediaType + "]");
            if (!mediaType.equals("")) {
                if (mediaType.equals("cdrom")) {
                    outputStreams = this.executeCommand("cat " + modelTemp);
                    stdout = outputStreams[0];
                    stderr = outputStreams[1];
                    if (stderr.length() != 0) {
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.readIde(): Error performing cat " + modelTemp + "; " + stderr + "\n");
                    } else {
                        modelType = stdout.trim();
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.readIde(): cat " + modelTemp + ", found hd" + abcd + " = [" + modelType + "]");
                        int index = modelType.toUpperCase().indexOf("DVD");
                        if (index != -1) {
                            deviceType = "DV";
                            deviceFile = "cdrom";
                        } else {
                            deviceType = "CD";
                            deviceFile = "cdrom";
                        }
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.readIde(): An unknown media type = " + mediaType + " was found.");
                }
            }
        }
        returnValues[0] = deviceType;
        returnValues[1] = deviceFile;
        Trace.trace(TRACE_MASKD, "DiscoverDevices.readIde(): deviceType = " + returnValues[0]);
        Trace.trace(TRACE_MASKD, "DiscoverDevices.readIde(): deviceFile = " + returnValues[1]);
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.readIde()");
        return returnValues;
    }

    private String[] executeCommand(String command) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.executeCommand(" + command + ")");
        String commandResults = new String("");
        String errorResults = new String("");
        String[] results = new String[2];
        try {
            String line;
            String[] commandArray = this.getCommandArray(command);
            for (int i = 0; i < commandArray.length; ++i) {
                Trace.trace(TRACE_MASKD, "DiscoverDevices.executeCommand(): commandArray[" + i + "] = " + commandArray[i]);
            }
            Process process = Runtime.getRuntime().exec(commandArray);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            do {
                if ((line = stdout.readLine()) == null) continue;
                commandResults = commandResults + line + "\n";
            } while (line != null);
            BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            do {
                if ((line = stderr.readLine()) == null) continue;
                errorResults = errorResults + line + "\n";
            } while (line != null);
        }
        catch (IOException ioexc) {
            Trace.trace(TRACE_MASKF, ioexc);
        }
        results[0] = commandResults;
        results[1] = errorResults;
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.executeCommand()");
        return results;
    }

    private String[] getCommandArray(String command) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getCommandArray(" + command + ")");
        String[] commandArray = new String[]{"bash", "-c", command};
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.getCommandArray()");
        return commandArray;
    }
}

